float2 R;
float Hue <float uimin=0.0; float uimax=1.0;> = 0.0;
float Saturation <float uimin=0.0; float uimax=1.0;> = 0.0;
float Brightness <float uimin=0.0; float uimax=1.0;> = 0.0;

texture tex0,tex1,tex2;
sampler s0=sampler_state{Texture=(tex0);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};
sampler s1=sampler_state{Texture=(tex1);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};
sampler s2=sampler_state{Texture=(tex2);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};

float3 hsv2rgb(float3 h){h.z+=max(0,h.y-1);float3 c=saturate((abs(frac(-h.x+float3(3,1,2)/3)*6-3)-1))*h.z;c=lerp(c,max(c.r,max(c.g,c.b)),1-h.y);return c;}
float3 rgb2hsv(float3 c){float cmax=max(c.r,max(c.g,c.b)),cmin=min(c.r,min(c.g,c.b)),l=cmax,d=(cmax-cmin),s=max(abs(c.r-c.g),max(abs(c.g-c.b),abs(c.r-c.b)))/cmax,h;float3 ch=(cmax==c);if(ch.r==ch.g&&ch.r==1)ch.rg=float2(1,0);if(ch.g==ch.b&&ch.g==1)ch.gb=float2(1,0);if(ch.b==ch.r&&ch.b==1)ch.br=float2(1,0);h=frac((dot(min(2,ch),(c.gbr-c.brg)/d+float3(0,2,4)))/6);if(cmax==cmin)h=s=0;return float3(h,s,l);}
float mx(float3 c){return max(c.x,max(c.y,c.z));}
float4 p0(float2 x:TEXCOORD0):color{float4 c0=tex2D(s0,x);float4 c1=tex2D(s1,x);
    float4 c=c0;
	float ctrl=mx(tex2D(s2,x).x);
	//c1=tex2D(s1,rgb2hsv(c0).x);
	float3 h0=rgb2hsv(c0);
	float3 h1=rgb2hsv(c1);
	float3 h=h0;

	h.x=rgb2hsv(lerp(hsv2rgb(float3(h0.x,.5,1)),hsv2rgb(float3(h1.x,.5,1)),Hue*ctrl));
	//if(x.x>.38)
	h.x=rgb2hsv(lerp(c0,c1,Hue*ctrl)).x;
	
	h.y=lerp(h0.y,h1.y,Saturation*ctrl);
	h.z=lerp(h0.z,h1.z,Brightness*ctrl);
	c.rgb=hsv2rgb(h);
    return c;
}
void vs2d(inout float4 vp:POSITION0,inout float2 uv:TEXCOORD0){vp.xy*=2;uv+=.5/R;}
technique MixHSV{pass pp0{vertexshader=compile vs_3_0 vs2d();pixelshader=compile ps_3_0 p0();}}

